#include <iostream>
#include <vector>
#include <algorithm>

double nadji_vreme_preticanja(int N, const std::vector<int>& x, const std::vector<int>& v, int k) {
    std::vector<double> vremena_preticanja;

    // Racunaj vremena preticanja
    for (int i = 0; i < N - 1; ++i) {
        for (int j = i + 1; j < N; ++j) {
            if (v[i] > v[j]) {
                double vreme_preticanja = static_cast<double>(x[j] - x[i]) / static_cast<double>(v[i] - v[j]);
                vremena_preticanja.push_back(vreme_preticanja);
            }
        }
    }

    // Sortiraj
    std::sort(vremena_preticanja.begin(), vremena_preticanja.end());

    // Proveri da li k-to preticanje postoji
    if (k > 0 && k <= vremena_preticanja.size()) {
        return vremena_preticanja[k - 1];
    } else {
        return -1; // ne postoji
    }
}

int main() {
    int N, k;

    // Unesi N i k
    std::cin >> N;
    std::cin >> k;

    // Unesi x i v
    std::vector<int> x(N), v(N);
    for (int i = 0; i < N; ++i) {
        std::cin >> x[i] >> v[i];
    }

    // Racunaj k-to vreme preticanja
    double vreme_preticanja = nadji_vreme_preticanja(N, x, v, k);

    // Rezultat
    if (vreme_preticanja >= 0) {
        std::cout << vreme_preticanja << std::endl;
    } else {
        std::cout << "Ne postoji!" << std::endl;
    }

    return 0;
}